<?php
/*
Plugin Name: Post Type Copy
Description: Copy posts between different post types
Version: 1.0
Author: مصطفی نور 
*/

// Add menu item to WordPress admin
function ptc_admin_menu() {
    add_menu_page(
        'کپی پست‌ها',
        'کپی پست‌ها',
        'manage_options',
        'post-type-copy',
        'ptc_admin_page',
        'dashicons-admin-page'
    );
}
add_action('admin_menu', 'ptc_admin_menu');

// Create admin page
function ptc_admin_page() {
    // Get all post types
    $post_types = get_post_types(['public' => true], 'objects');
    
    // Handle form submission
    if (isset($_POST['ptc_copy_submit'])) {
        $source_type = sanitize_text_field($_POST['source_type']);
        $target_type = sanitize_text_field($_POST['target_type']);
        
        ptc_copy_posts($source_type, $target_type);
        echo '<div class="notice notice-success"><p>پست‌ها با موفقیت کپی شدند!</p></div>';
    }
    
    ?>
    <div class="wrap">
        <h1>کپی پست‌ها بین انواع مختلف</h1>
        <form method="post">
            <table class="form-table">
                <tr>
                    <th scope="row">نوع پست مبدا:</th>
                    <td>
                        <select name="source_type" required>
                            <?php foreach ($post_types as $type): ?>
                                <option value="<?php echo esc_attr($type->name); ?>">
                                    <?php echo esc_html($type->labels->name); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row">نوع پست مقصد:</th>
                    <td>
                        <select name="target_type" required>
                            <?php foreach ($post_types as $type): ?>
                                <option value="<?php echo esc_attr($type->name); ?>">
                                    <?php echo esc_html($type->labels->name); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
            </table>
            <?php submit_button('کپی پست‌ها', 'primary', 'ptc_copy_submit'); ?>
        </form>
    </div>
    <?php
}

// Function to copy posts
function ptc_copy_posts($source_type, $target_type) {
    $args = array(
        'post_type' => $source_type,
        'posts_per_page' => -1,
        'post_status' => 'publish'
    );
    
    $posts = get_posts($args);
    
    foreach ($posts as $post) {
        // Get all post meta
        $post_meta = get_post_meta($post->ID);
        
        // Create new post array
        $new_post = array(
            'post_title' => $post->post_title,
            'post_content' => $post->post_content,
            'post_excerpt' => $post->post_excerpt,
            'post_status' => 'publish',
            'post_type' => $target_type,
            'post_author' => $post->post_author,
            'post_thumbnail' => get_post_thumbnail_id($post->ID)
        );
        
        // Insert the new post
        $new_post_id = wp_insert_post($new_post);
        
        // Copy post meta
        foreach ($post_meta as $key => $values) {
            foreach ($values as $value) {
                add_post_meta($new_post_id, $key, maybe_unserialize($value));
            }
        }
        
        // Copy featured image
        if (has_post_thumbnail($post->ID)) {
            set_post_thumbnail($new_post_id, get_post_thumbnail_id($post->ID));
        }
        
        // Copy taxonomies
        $taxonomies = get_object_taxonomies($source_type);
        foreach ($taxonomies as $taxonomy) {
            $terms = wp_get_object_terms($post->ID, $taxonomy, array('fields' => 'slugs'));
            wp_set_object_terms($new_post_id, $terms, $taxonomy);
        }
    }
}